//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 5: Some Applications of the Laws of Thermodynamics
//Example: 5.29 Page 190
//Title: Brayton cycle
//===================================================

package Ex5_29

model Ex5_29_a

//============
//Parameter Section
parameter Real T1(unit = "K") = 300 "Temperature at the beginning of compression stroke";
parameter Real P1(unit = "kPa") = 100 "Pressure at the beginning of compression stroke";
parameter Real T3(unit = "K") = 1200 "Maximum temperature in the cycle";
parameter Real P3(unit = "kPa") = 500 "Maximum pressure in the cycle";
parameter Real Cp(unit = "kJ/kg K") = 1.005 "Specific heat of air at const. pressure";
parameter Real Cv(unit = "kJ/kg K") = 0.718 "Specific heat of air at const. volume";

//===========
//Variable Section
Real gamma(unit = "-") "Ratio of specific heats";
Real P4(unit = "kPa") "Pressure after expansion";
Real P2(unit = "kPa") "Pressure after compression";
Real T4(unit = "K") "Temperature after expansion";
Real T2(unit = "K") "Temperature after compression";

//===========
//Equation Section
equation
P4 = P1;
P2 = P3;
gamma = Cp/Cv;
//ISentropic compression
P2/P1 = (T2/T1)^(gamma/(gamma-1));
//Isentropic expansion
P3/P4 = (T3/T4)^(gamma/(gamma-1));

end Ex5_29_a;

//===========

model Ex5_29_b

extends Ex5_29_a;

//===========
//Variable Section
Real Wc(unit = "kJ/kg") "Work required by the compressor";

//============
//Equation Section
equation
Wc = Cp*(T2-T1);

end Ex5_29_b;

//==========
model Ex5_29_c

extends Ex5_29_a;

//===========
//Variable Section
Real Wt(unit = "kJ/kg") "Work done by the compressor";

//============
//Equation Section
equation
Wt = Cp*(T3-T4);

end Ex5_29_c;

//==========

model Ex5_29_d

extends Ex5_29_a;

//==========
//Variable Section
Real eta(unit = "-") "Thermal efficiency of the cycle";

//===========
//Equation Section
equation 
eta = 1-(P1/P2)^((gamma-1)/gamma);

end Ex5_29_d;

//===========

end Ex5_29;

//===================================================
