//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 5: Some Applications of the Laws of Thermodynamics
//Example: 5.7 Page 140
//Title: Discharge velocity from nozzle
//===================================================

model Ex5_7

//===========
//Parameter Section
parameter Real P1(unit = "kPa") = 600 "Inlet pressure of steam";
parameter Real T1(unit = "K") = 573 "Inlet temperature of steam";
parameter Real H1(unit = "kJ/kg") = 3062 "Inlet enthalpy of steam";
parameter Real m(unit = "kg/s") = 10 "Mass flow rate of steam";
parameter Real P2(unit = "kPa") = 100 "Outlet pressure of steam";
parameter Real T2(unit = "K") = 473 "Outlet temperature of steam";
parameter Real H2(unit = "kJ/kg") = 2875 "Outlet enthalpy of steam";
parameter Real Q(unit = "kW") = -100 "Heat loss of to the surroundings";
parameter Real u1(unit = "m/s") = 0 "Inlet velocity of the steam";

//=========
//Variable Section
Real delta_H(unit = "kJ/kg") "Change in enthalpy of steam";
Real u2(unit = "m/s") "Discharge velocity of steam";

//=========
//Equation Section
equation
delta_H = (H2-H1);
//Reduced energy balance equation neglecting potential energy and shaft work = 0
(u2^2/2)-(u1^2/2) = (Q/m-delta_H)*10^3;

end Ex5_7;

//===================================================
