//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 6: Thermodynamic Properties of Pure Fluids
//Example: 6.22 Page 247
//Title: Fugacity of ammonia
//===================================================

model Ex6_22


//===========
//Parameter Section
parameter Real T(unit = "K") = 298 "Temperature of ammonia";
parameter Real P(unit = "bar") = 10 "Pressure of ammonia";
parameter Real b(unit = "m^3/mol") = 3.707/10^5 "Constant";
parameter Real R(unit = "J/mol K") = 8.314 "Universsal gas constant";

//===========
//Variable Section
Real f(unit = "bar") "Fugacity of ammonia";

//===========
//Equation Section
equation
log(f/P) = (P*10^5*b)/(R*T);    //Reduced form of Eqn. 6.127 Ref pg no. 247

end Ex6_22;

//===================================================
