//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 6: Thermodynamic Properties of Pure Fluids
//Example: 6.27 Page 252
//Title: Fugacity and Fugacity coefficient of steam
//===================================================

model Ex6_27


//============
//Parameter Section
parameter Real T(unit = "K") = 623 "Temperature";
parameter Real P(unit = "kPa") = 1000 "Pressure";
parameter Real fo(unit = "kPa") = 101.3 "Standard fugacity ";
parameter Real H(unit = "kJ/kg") = 3159 "Enthalpy at 1000 kPa and 623 K";
parameter Real S(unit = "kJ/kg K") = 7.3 "Entropy at 1000 kPa and 623 K";
parameter Real Ho(unit = "kJ/kg") = 3176 "Enthalpy at 101.3 kPa and 623 K";
parameter Real So(unit = "kJ/kg K") = 8.38 "Entropy at 1000 kPa and 623 K";
parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";
parameter Real M(unit = "kg/kmol") = 18 "Molecular weight of water";

//============
//Variable Section
Real f(unit = "bar") "Fugacity";

//============
//Equation Section
equation
log((f*10^2)/fo) = (1/((R/M)*T))*((H-Ho)-(T*(S-So)));    //Using Eqn. 6.140 pg no. 252

end Ex6_27;

//===================================================
