//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 6: Thermodynamic Properties of Pure Fluids
//Example: 6.28 Page 253
//Title: Fugacity 
//===================================================

model Ex6_28

//============
//Parameter Section
parameter Real T(unit = "K") = 473 "Temperature of gas";
parameter Real P(unit = "bar") = 50 "Pressure of gas";
parameter Real rho(unit = "kg/m^3") = 24.3 "Density of ammonia";
parameter Real M(unit = "kg/kmol") = 17 "Molecular weight of ammonia";
parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";

//============
//Variable Section
Real V(unit = "m^3/kmol") "Molar volume of ammonia";
Real f(unit = "bar") "Fugacity";

//============
//Equation Section
equation
V = M/rho;
f = (((V/10^3)*(P*10^5)^2)/(R*T))/10^5;   //Using Eqn. 6.142 pg no. 253

end Ex6_28;

//===================================================
