//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 6: Thermodynamic Properties of Pure Fluids
//Example: 6.29 Page 254
//Title: Fugacity of liquid water
//===================================================

model Ex6_29

//============
//Parameter Section
parameter Real T(unit = "K") = 303 "Temperature of liquid water";
parameter Real P(unit = "bar") = 10 "Pressure of liquid water";
parameter Real Ps(unit = "kPa") = 4.241 "Saturation pressure at 303 K";
parameter Real V(unit = "m^3/kg") = 1.004/10^3 "Specific volume of liquid water at 303 K";
parameter Real M(unit = "kg/kmol") = 18 "Molecular weight of water";
parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";

//============
//Variable Section
Real f_sat(unit = "bar") "Saturation fugacity";
Real f(unit = "bar") "Fugacity of liquid water";

//============
//Equation Section
equation
f_sat = Ps/10^2;
log(f/f_sat) = ((V*M/10^3)/(R*T))*(P-Ps)*10^5;

end Ex6_29;

//===================================================
