//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 6: Thermodynamic Properties of Pure Fluids
//Example: 6.3 Page 215
//Title: Melting point of mercury
//===================================================

model Ex6_3

//============
//Parameter Section
parameter Real rho_l(unit = "kg/m^3") = 13.69*10^3 "Density of mercury in the liquid state";
parameter Real rho_s(unit = "kg/m^3") = 14.193*10^3 "Density of mercury in the solid state";
parameter Real T1(unit = "K") = 234.33 "Melting point of mercury at 1 bar";
parameter Real P1(unit = "bar") = 1 "Pressure";
parameter Real delta_H(unit  = "kJ/kg") = 9.7876 "Heat of fusion of mercury";
parameter Real P2(unit = "bar") = 2 "Pressure";

//===========
//Variable Section
Real delta_V(unit  = "m^3/kg") "Change in specific volume";
Real T2(unit = "K") "Melting point of mercury at 2 bar";

//==========
//Equation Section
equation
delta_V = (1/rho_l)-(1/rho_s);
log(T2/T1) = ((delta_V)/(delta_H))*(P2-P1)*10^2;    //Clapeyron equation

end Ex6_3;

//===================================================
