//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 6: Thermodynamic Properties of Pure Fluids
//Example: 6.4 Page 216
//Title: Entropy-Heat capacity relationship
//===================================================

model Ex6_4

//============
//Parameter Section
parameter Real T1(unit = "K") = 300 "Initial temperature";
parameter Real T2(unit = "K") = 800 "Final temperature";

//============
//Variable Section
Real delta_S(unit = "J/mol K") "Increase in entropy of solid magnesium";

//============
//Equation Section
equation
//Cp = 26.04+(5.586*10^-3*T)+(28.476*10^4*T^-2)
delta_S = ((26.04*log(T2/T1))+((5.586/10^3)*(T2-T1))-(((28.476*10^4)/2)*((1/T2^2)-(1/T1^2))));

end Ex6_4;

//===================================================
