//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 6: Thermodynamic Properties of Pure Fluids
//Example: 6.7 Page 222
//Title: Internal energy, Enthalpy, Entropy, and Free energy
//===================================================

model Ex6_7

//============
//Parameter Section
parameter Real n(unit = "mol") = 1 "Mole of nitrogen gas";
parameter Real T(unit = "K") = 773 "Temperature of nitrogen gas";
parameter Real P(unit = "bar") = 100 "Pressure of nitrogen gas";
parameter Real Ho(unit = "J/mol") = 0 "Enthalpy of nitrogen gas at 273 K and 1 bar";
parameter Real So(unit = "J/mol K") = 192.4 "Entropy of nitrogen at 298 K and 1  bar";
parameter Real To1(unit = "K") = 273 "Reference temperature";
parameter Real To2(unit = "K") = 298 "Reference temperature";
parameter Real Po(unit = "bar") = 1 "Reference pressure";
parameter Real R(unit = "J/mol K") = 8.314 "Universsal gas constant";

//============
//Variable Section
Real delta_H1(unit = "J/mol") "Change in enthalpy of step 1";
Real delta_S1(unit = "J/mol K") "Change in entropy of step 1";
Real H1(unit = "J/mol") "Enthalpy after step 1";
Real S1(unit = "J/mol K") "Entropy after step 1";
Real delta_H2(unit = "J/mol") "Change in enthalpy of step 2";
Real delta_S2(unit = "J/mol K") "Change in entropy of step 2";
Real H2(unit = "J/mol") "Enthalpy after step 2";
Real S2(unit = "J/mol K") "Entropy after step 2";
Real U(unit = "J/mol") "Internal energy";
Real G(unit = "J/mol") "Gibbs free energy";

//============
//Equation Section
equation
delta_H1 = ((27.3*(T-To1))+((4.2/10^3)*(T^2-To1^2)/2));   
delta_S1 = ((27.3*log(T/To2))+((4.2/10^3)*(T-To2)));
H1 = Ho+delta_H1;
S1 = So+delta_S1;
delta_H2 = 0;
delta_S2 = -R*log(P/Po);
H2 = H1+delta_H2;
S2 = S1+delta_S2;
U = H2-(R*T);
G = H2 - (T*S2);

end Ex6_7;

//===================================================
