//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 6: Thermodynamic Properties of Pure Fluids
//Example: 6.8 Page 223
//Title: Change in internal energy
//===================================================

model Ex6_8

//==========
//Parameter Section
parameter Real n(unit = "kmol") = 25 "Moles of gas";
parameter Real P1(unit = "kPa") = 1.0132*10^4 "Initial pressure";
parameter Real P2(unit = "kPa") = 1.0132*10^2 "Final pressure";
parameter Real T(unit = "K") = 373 "Temperature";
parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";
parameter Real a(unit = "kN*m^4") = 365 "Van der waals constant";
parameter Real b(unit = "m^3") = 0.043 "Van der waals constant";

//==========
//Variable Section
Real V1(unit = "m^3") "Initial volume of the gas";
Real V2(unit = "m^3") "Final volume of the gas";
Real delta_U(unit = "kJ") "Change in internal energy";

//==========
//Equation Section
equation
(P1+(a/V1^2))*(V1-b) = R*T;   //From give equation of state
(P2+(a/V2^2))*(V2-b) = R*T;
delta_U = -n*a*((1/V2)-(1/V1));   //Using Eqn. (iv) pg no. 224

end Ex6_8;

//Answer may slightly vary due to rounding off values

//===================================================
