//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 7: Properties of Solutions
//Example: 7.12 Page 300
//Title: Activity and activity coefficient
//===================================================

package Ex7_12

model Ex7_12_a

//============
//Parameter Section
parameter Real PBs(unit = "bar") = 0.386 "Vapour pressure of pure chloroform";
parameter Real KB(unit = "bar") = 0.217 "Henry's law constant";   //From Example 7.11
parameter Real pb[5](each unit = "bar") = {0.288,0.187,0.108,0.046,0} "Vapour pressure of chloroform";
parameter Real x_A[5](each unit = "-") = {0.2,0.4,0.6,0.8,1} "Mole fraction of acetone" ;

//============
//Variable Section
Real x_B[5](each unit = "-") "Mole fraction of chloroform";
Real alphaB[5](each unit = "-") "Activity of chloroform by Lewis-Randall rule";
Real gammaB[5](each unit = "-") "Activity coefficient of chloroform by Lewis-Randall rule";

//============
//Equation Section
equation
//Lewis-Randall Rule
for i in 1:5 loop
x_B[i] = 1-x_A[i];    //Sum of mole fractions is unity
alphaB[i] = pb[i]/PBs;
gammaB[i] = alphaB[i]/x_B[i];
end for;

end Ex7_12_a;

//===========

model Ex7_12_b

extends Ex7_12_a;

//===========
//Variable Section
Real alpha_B[5](each unit = "-") "Activity of chloroform by Henry's law";
Real gamma_B[5](each unit = "-") "Activity coefficient of chloroform by Henry's law";

//===========
//Equation Section
equation
//Henry's law
for i in 1:5 loop
alpha_B[i] = pb[i]/KB;
gamma_B[i] = alpha_B[i]/x_B[i];
end for;

end Ex7_12_b;

//============

end Ex7_12;

