//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 7: Properties of Solutions
//Example: 7.17 Page 312
//Title: Partial molar enthalpies at infinite dilution
//===================================================

model Ex7_17

//============
//Parameter Section
//delH = x1*x2*(40*x1+20*x2)
parameter Real H1(unit = "J/mol") = 400 "Enthalpy of pure liquid 1 at 298 K and 1 bar";
parameter Real H2(unit = "J/mol") = 600 "Enthalpy of pure liquid 2 at 298 K and 1 bar";

//============
//Variable Section
Real x1(unit = "-") "Mole fraction of liquid 1";
Real x2(unit = "-") "Mole fraction of liquid 2";
Real delH1_inf(unit = "J/mol") "Change in enthalpy of liquid 1 at infinite dilution";
Real H1_inf(unit = "J/mol") "Partial molar enthalpy of liquid 1 at infinite dilution";
Real delH2_inf(unit = "J/mol") "Change in enthalpy of liquid 2 at infinite dilution";
Real H2_inf(unit = "J/mol") "Partial molar enthalpy of liquid 2 at infinite dilution";

//============
//Equation Section
equation
//delH1_bar = 20*(1-x1)^2*(2*x1+1)
x1 = 0;
delH1_inf = 20*(1-x1)^2*(2*x1+1);    //At infinite dilution of liquid 1,delH1_bar = delH1_inf
H1_inf = delH1_inf+H1;
//delH2_bar = 40*x1^3
x2 = 0;
delH2_inf = 40*(1-x2)^3;    //At infinite dilution of liquid 2,delH2_bar = delH2_inf
H2_inf = delH2_inf+H2;

end Ex7_17;

//===================================================
