//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 7: Properties of Solutions
//Example: 7.19 Page 314
//Title: Change in entropy for the content of the vessel
//===================================================

model Ex7_19

//=============
//Parameter Section
parameter Real n1(unit = "mol") = 100 "Moles of nitrogen at 298 K and 1 bar";
parameter Real n2(unit = "mol") = 100 "Moles of oxygen at 298 K and 1 bar";
parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";

//============
//Variable Section
Real x1(unit = "-") "Mole fraction of nitrogen";
Real x2(unit = "-") "Mole fraction of oxygen";
Real delta_S(unit = "J/mol K") "Change in entropy";
Real del_S(unit = "J/K") "Total change in entropy";

//============
//Equation Section
equation
x1 = n1/(n1+n2);
x2 = 1-x1;
delta_S = -R*((x1*log(x1))+(x2*log(x2)));   //Mixing of ideal solutions
del_S = delta_S*(n1+n2);

end Ex7_19;

//===================================================
