//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 7: Properties of Solutions
//Example: 7.23 Page 316
//Title: Tempearature after mixing
//===================================================

model Ex7_23

//============
//Parameter Section
parameter Real To(unit = "K") = 298 "Initial temperature";
parameter Real delta_Hs(unit = "J/mol") =  -758 "Heat of mixing for 20 % mole ethanol-water at 298 K";
parameter Real Cpm(unit = "'J/mol K") = 97.65 "Mean heat capacity of solution at 298 K";

//============
//Variable Section
Real delta_H(unit = "J/mol") "Change in enthalpy";
Real T(unit = "K") "Final temperature after mixing";

//============
//Equation Section
equation
delta_H = 0;   //Adiabatic mixing
delta_H = delta_Hs + Cpm*(T-To);

end Ex7_23;

//===================================================
