//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 7: Properties of Solutions
//Example: 7.4 Page 278
//Title: Partial molar properties and properties of solutions
//===================================================

package Ex7_4

model Ex7_4_a

//============
//Parameter Section
parameter Real xe_1(unit = "%") = 96 "Percent by mass of alcohol";
parameter Real xw_1(unit = "%") = 4 "Percent by mass of water";
parameter Real xe_2(unit = "%") = 56 "Percent by mass of alcohol";
parameter Real xw_2(unit = "%") = 44 "Percent by mass of water";
parameter Real Ve_1(unit = "m^3/kg") = 1.273/10^3 "Partial specific volume of ethanol for 96% alcohol solution";
parameter Real Vw_1(unit = "m^3/kg") = 0.816/10^3 "Partial specific volume of water for 96% alcohol solution";
parameter Real Ve_2(unit = "m^3/kg") = 1.243/10^3 "Partial specific volume of ethanol for 56% alcohol solution";
parameter Real Vw_2(unit = "m^3/kg") = 0.953/10^3 "Partial specific volume of water for 56% alcohol solution";
parameter Real rho_w(unit = "kg/m^3") = 997 "Density of water";
parameter Real Ve(unit = "m^3") = 2/10^3 "Volume of laboratory alcohol";

//===========
//Variable Section
Real mVe_1(unit = "m^3/kg") "Specific volume of laboratory alcohol";
Real me(unit = "kg") "Mass of laboratory alcohol";
Real m(unit = "kg") "Mass of water to be added";
Real V(unit = "m^3") "Volume of water to be added";

//===========
//Equation Section
equation
mVe_1 = ((xe_1/100)*Ve_1)+((xw_1/100)*Vw_1);
me = Ve/mVe_1;
m = ((me*(xe_1/100))/(xe_2/100))-me;    //Alcohol balance
V = m/rho_w;

end Ex7_4_a;

//=============

model Ex7_4_b

extends Ex7_4_a;

//===========
//Variable Section
Real me_2(unit = "kg") "Mass of dilute alcohol obtained";
Real mVe_2(unit = "m^3/kg") "Specific volume of 56% alcohol";
Real Ve2(unit = "m^3") "Volume of dilute alcohol obtained";

//============
//Equation Section
equation
me_2 = me+m;
mVe_2 = ((xe_2/100)*(Ve_2))+((xw_2/100)*(Vw_2));
Ve2 = mVe_2*me_2;

end Ex7_4_b;

//=============

end Ex7_4;
