//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 7: Properties of Solutions
//Example: 7.6 Page 282
//Title: Pure component and partial molar enthalpies
//===================================================

package Ex7_6

model Ex7_6_b

//============
//Variable Section
Real x1(unit = "-") "Mole fraction of first component";
Real x2(unit = "-") "Mole fraction of second component";
Real H1(unit = "J/mol") "Entalpy of first component";
Real H2(unit = "J/mol") "Enthalpy of second component";

//============
//Equation Section
equation 
x1 = 1;
H1 = 420-(60*x1^2)+(40*x1^3);   //From Eqn. 7.27 pg no. 283
x2 = 1;
H2 = 600+(40*(1-x2)^2);   //From Eqn. 7.28 pg no. 283

end Ex7_6_b;

//===========

model Ex7_6_c

//============
//Variable Section
Real x1(unit = "-") "Mole fraction of first component";
Real x2(unit = "-") "Mole fraction of second component";
Real H_1(unit = "J/mol") "Partial molar entalpy of first component at infinite dilution";
Real H_2(unit = "J/mol") "Partial molar entalpy of second component at infinite dilution";

//============
//Equation Section
equation 
x1 = 0;
H_1 = 420-(60*x1^2)+(40*x1^3);   //From Eqn. 7.27 pg no. 283
x2 = 0;
H_2 = 600+(40*(1-x2)^2);   //From Eqn. 7.28 pg no. 283

end Ex7_6_c;

//============

end Ex7_6;

//===================================================
