//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 8: Phase Equilibria
//Example: 8.15 Page 376
//Title: Liquid phase activity coefficient
//===================================================

package Ex8_15

model Ex8_15_a

//============
//Parameter Section
parameter Real T(unit = "K") = 318 "Temperature of the solution";
parameter Real P(unit = "kPa") = 24.4 "Pressure of the solution";
parameter Real x1(unit = "-") = 0.3 "Composition of ethanol in liquid";
parameter Real y1(unit = "_") = 0.634 "Composition of ethanol in vapour";
parameter Real P1s(unit = "kPa") = 23.06 "Vapour pressure of ethanol";
parameter Real P2s(unit = "kPa") = 10.05 "Vapour pressure of toluene";

//=============
//Variable Section
Real x2(unit = "-")"Composition of toluene in liquid";
Real y2(unit = "-")"Composition of toluene in vapour";
Real gamma1(unit = "-") "Activity coefficient of ethanol";
Real gamma2(unit = "-") "Activity coefficient of toluene";

//=============
//Equation Section
equation
x2 = 1-x1;
y2 = 1-y1;
gamma1 = (y1*P)/(x1*P1s);
gamma2 = (y2*P)/(x2*P2s);

end Ex8_15_a;

//=============

model Ex8_15_b

extends Ex8_15_a;

//============
//Variable Section
Real GE_RT(unit = "-") "Excess free energy";

//============
//Equation Section
equation
GE_RT = (x1*log(gamma1)+x2*log(gamma2));    //From Eqn. 7.145 pg no. 319

end Ex8_15_b;

//============

end Ex8_15;

//===================================================
