//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 8: Phase Equilibria
//Example: 8.18 Page 379
//Title: Formation of azeotrope
//===================================================

model Ex8_18

//============
//Parameter Section
parameter Real T(unit = "K") = 341 "Temperature";
parameter Real lambda12(unit = "-") = 0.1751 "Wilson parameter";
parameter Real lambda21(unit = "-") = 0.3456 "Wilson parameter";
parameter Real P1s(unit = "kPa") = 68.75 "Vapour pressure of methanol";
parameter Real P2s(unit = "kPa") = 115.89 "Vapour pressure of benzene";

//============
//Variable Section
Real gamma1_inf(unit = "-") "Activity coefficient of methanol at infinite dilution";
Real gamma2_inf(unit = "-") "Activity coefficient of benzene at infinite dilution";
Real x1a(unit = "-") "Mole fraction of methanol";
Real x2a(unit = "-") "Mole fraction of benzene";
Real gamma1a(unit = "-")"Activity coefficient of methanol at x1=0";
Real gamma2a(unit = "-")"Activity coefficient of benzene at x1=0";
Real x1b(unit = "-") "Mole fraction of methanol";
Real x2b(unit = "-") "Mole fraction of benzene";
Real alpha1(unit = "-") "Relative volatility at x1=0";
Real alpha2(unit = "-") "Relative volatility at x1=1";
Real gamma1b(unit = "-")"Activity coefficient of methanol at x1=1";
Real gamma2b(unit = "-")"Activity coefficient of benzene at x1=1";

//============
//Equation Section
equation
log(gamma1_inf) = -log(lambda12)+1-lambda21;    //Putting x1=0 in Wilson equation
log(gamma2_inf) = -log(lambda21)+1-lambda12;    //Putting x2=0 in Wilson equation
x1a = 0;    
x2a = 1-x1a;
gamma1a = gamma1_inf;
log(gamma2a) = -log(x2a+(lambda21*x1a))+(x1a*((lambda21/(x2a+(lambda21*x1a)))-(lambda12/((lambda12*x2a)+x1a)))); 
                                                                          //Wilson equation
alpha1 = (gamma1a*P1s)/(gamma2a*P2s);   //Using Eqn. (iv) p.379
x1b = 1;
x2b = 1-x1b;
log(gamma1b) = -log(x1b+(lambda12*x2b))+(x2b*((lambda12/(x1b+(lambda12*x2b)))-(lambda21/((lambda21*x1b)+x2b))));    
                                                                          //Wilson equation
gamma2b = gamma2_inf;
alpha2 = (gamma1b*P1s)/(gamma2b*P2s);   //Using Eqn. (iv) p.379

/* This system forms an azeotrope since relative volatility is greater than unity for x1=0 and less than unity for x2=0 */

end Ex8_18;
