//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 8: Phase Equilibria
//Example: 8.24 Page 385
//Title: Parameters in Wilson equation
//===================================================

model Ex8_24

//=============
//Parameter Section
parameter Real x1(unit = "-")  = 0.842 "Mole fraction of methanol";
parameter Real P(unit = "kPa") = 101.3 "Pressure";
parameter Real T(unit = "K") = 337.5 "Temperature";
parameter Real A1(unit = "-") = 16.12609 "Antoine eqn constant of methanol";
parameter Real B1(unit = "-") = 3394.286 "Antoine eqn constant of methanol";
parameter Real C1(unit = "-") = 43.2 "Antoine eqn constant of methanol";
parameter Real A2(unit = "-") = 14.04357 "Antoine eqn constant of methyl ethyl ketone";
parameter Real B2(unit = "-") = 2785.225 "Antoine eqn constant of methyl ethyl ketone";
parameter Real C2(unit = "-") = 57.2 "Antoine eqn constant of methyl ethyl ketone";

//============
//Variable Section
Real P1s(unit = "kPa") "Vapour pressure of methanol";
Real P2s(unit = "kPa") "Vapour pressure of methyl ethyl ketone";
Real x2(unit = "-") "Mole fraction of methyl ethyl ketone";
Real gamma1(unit = "-") "Activity coefficient of methanol";
Real gamma2(unit = "-") "Activity coefficient of methyl ethyl ketone";
Real lambda12(unit = "-") "Wilson equation constant";
Real lambda21(unit = "-") "Wilson equation constant";

//============
//Equation Section
equation
log(P1s) = A1-(B1/(T-C1));    //Antoine equation
log(P2s) = A2-(B2/(T-C2));    ////Antoine equation
x2 = 1-x1;
gamma1 = P/P1s;
gamma2 = P/P2s;
(((gamma2*x2)/(1-((lambda12*x1)/(x1+(lambda12*x2)))+((x1/x2)*log(gamma1*(x1+(lambda12*x2))))))^(x2/x1)*((gamma1*(x1+(lambda12*x2))))) = 1;    //Rearranging Wilson equation
log(gamma1) = -log(x1+(lambda12*x2))+(x2*((lambda12/(x1+(lambda12*x2)))-(lambda21/((lambda21*x1)+x2))));   
                       //Wilson equation

end Ex8_24;

//===================================================
