//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 8: Phase Equilibria
//Example: 8.25 Page 391
//Title: Bubble point, dew point, composition of liquid and vapour
//===================================================

package Ex8_25

model Ex8_25_a

//============
//Parameter Section
parameter Real xi[3](each unit = "-") = {0.45,0.30,0.25} "Mole fraction of methanol,ethanol,n-propanol in liquid";
parameter Real P(unit = "kPa") = 101.3 "Pressure";
parameter Real T[4](each unit = "K") = {333,343,353,363} "Temperature";
parameter Real PAs[4](each unit = "kPa") = {81.97,133.29,186.61,266.58} "Vapour pressure of methanol";
parameter Real PBs[4](each unit = "kPa") = {49.32,73.31,106.63,166.61} "Vapour pressure of ethanol";
parameter Real PCs[4](each unit = "kPa") = {39.32,62.65,93.3,133.29} "Vapour pressure of n-propanol";
parameter Real Pis[3](each unit = "kPa") = {137.3,76.2,65.4} "Vapour pressure of components at 344.6 K";

//============
//Variable Section
Real T1(unit = "K") "Temperature";
Real T2(unit = "K") "Temperature";
Real Tb(unit = "K") "Bubble point temperature";
Real Ki[3](each unit = "-") "Factor";
Real yi[3](each unit = "%") "Vapour composition of methanol, ethanol and propanol";

//============
//Equation Section
equation
T1 = 344;   //Ref pg no. 392
T2 = 345;
Tb = T2-(((1-0.98)/(1.015-0.98))*(T2-T1));    //Interpolation

for i in 1:3 loop
Ki[i] = Pis[i]/P;
yi[i] = Ki[i]*xi[i]*100;
end for;

end Ex8_25_a;

//=============

model Ex8_25_b

//============
//Parameter Section
parameter Real yi[3](each unit = "-") = {0.45,0.30,0.25} "Mole fraction of methanol,ethanol,n-propanol in vapour";
parameter Real P(unit = "kPa") = 101.3 "Pressure";
parameter Real T[4](each unit = "K") = {333,343,353,363} "Temperature";
parameter Real Pis[3](each unit = "kPa") = {153.28,85.25,73.31} "Vapour pressure of components at 347.5 K";

//============
//Variable Section
Real Td(unit = "K") "Dew point temperature";
Real Ki[3](each unit = "-") "Factor";
Real xi[3](each unit = "%") "Liquid composition of methanol, ethanol and propanol";

//============
//Equation Section
equation
Td = 347.5;   //Determined from trails

for i in 1:3 loop
Ki[i] = Pis[i]/P;
xi[i] = yi[i]/Ki[i]*100;
end for;

end Ex8_25_b;

//============

end Ex8_25;
