//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 8: Phase Equilibria
//Example: 8.7 Page 357
//Title: Pressure at the beginning and end of vapourisation
//===================================================

model Ex8_7

//============
//Parameter Section
parameter Real P1s(unit = "kPa") = 135.4 "Vapour pressure of benzene";
parameter Real P2s(unit = "kPa") = 54 "Vapour pressure of toluene";

//============
//Variable Section
Real x(unit = "-") "Mole fraction of benzene in liquid";
Real y(unit = "-") "Mole fraction of benzene in vapour";
Real P1(unit = "kPa") "Pressure at the beginning of vapourisation";
Real P2(unit = "kPa") "Pressure at the end of vapourisation";

//=============
//Equation Section
equation
x = 0.5;
P1 = P2s + (P1s-P2s)*x;   //From Eqn. 8.51 pg no. 353
y = 0.5;
P2 = (P1s*P2s)/(P1s-(y*(P1s-P2s)));   //Rearranging Eqn. 8.54  pg no. 353

end Ex8_7;

//===================================================
