//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 8: Phase Equilibria
//Example: 8.9 Page 358
//Title: Vapour liquid equilibrium
//===================================================

package Ex8_9

model Ex8_9_a

//============
//Parameter Section
parameter Real A1(unit = "-") = 14.5463 "Acetone Antoine eqn. constant";
parameter Real B1(unit = "-") = 2940.46 "Acetone Antoine eqn. constant";
parameter Real C1(unit = "-") = 35.93 "Acetone Antoine eqn. constant";
parameter Real A2(unit = "-") = 14.2724 "Acetonitrile Antoine eqn. constant";
parameter Real B2(unit = "-") = 2945.47 "Acetonitrile Antoine eqn. constant";
parameter Real C2(unit = "-") = 49.15 "Acetonitrile Antoine eqn. constant";
parameter Real T(unit = "K")  = 327 "Bubble point of the mixture";
parameter Real P(unit = "kPa") = 65 "Total pressure";

//============
//Variable Section
Real P1s_a(unit = "kPa") "Vapour pressure of acetone";
Real P2s_a(unit = "kPa") "Vapour pressure of acetonitrile";
Real x1a(unit = "-") "Composition of acetone in  liquid";
Real y1a(unit = "-") "Composition of  acetone in vapour";

//============
//Equation Section
equation
log(P1s_a) = A1-(B1/(T-C1));    //Antoine equation
log(P2s_a) = A2-(B2/(T-C2));    //Antoine equation
x1a = (P-P2s_a)/(P1s_a-P2s_a);     //From Eqn.8.51 pg no.353
y1a = (x1a*P1s_a)/P;       //From Eqn.8.54 pg no.353

end Ex8_9_a;

//=============

model Ex8_9_b

extends Ex8_9_a;

//============
//Parameter Section
parameter Real x1b(unit = "-") = 0.4 "Mole fraction of acetone in liquid";
parameter Real P_b(unit = "kPa") = 65 "Pressure";

//============
//Variable Section
Real Tb(unit = "K") "Equilibrium temperature";
Real Pb(unit = "kPa") "Equilibrium pressure";
Real P1s_b(unit = "kPa") "Vapour pressure of acetone at 330.4 K";
Real P2s_b(unit = "kPa") "Vapour pressure of acetonitrile at 330.4 K";
Real y1b(unit = "-") "Mole fraction of acetone in vapour";

//============
//Equation Section
equation 
Tb = 330.4;   //Equilibrium temperature from trials
log(P1s_b) = A1-(B1/(Tb-C1));    //Antoine equation
log(P2s_b) = A2-(B2/(Tb-C2));    //Antoine equation
Pb = P2s_b+(x1b*(P1s_b-P2s_b));
y1b = (x1b*P1s_b)/Pb;   //From Eqn.8.54 pg no.353

end Ex8_9_b;

//===========

model Ex8_9_c

extends Ex8_9_a;

//===========
//Parameter Section
parameter Real x1c(unit = "-") = 0.4 "Mole fraction of acetone in liquid";
parameter Real Tc(unit = "K") = 327 "Temperature";

//============
//Variable Section
Real Pc(unit = "kPa") "Equilibrium pressure";
Real y1c(unit = "-") "Mole fraction of acetone in vapour";

//============
//Equation Section
equation 
Pc = P2s_a+(x1c*(P1s_a-P2s_a));
y1c = (x1c*P1s_a)/Pc;   //From Eqn.8.54 pg no.353

end Ex8_9_c;

//=============

model Ex8_9_d

extends Ex8_9_a;

//==============
//Parameter Section
parameter Real y1d(unit = "-") = 0.4 "Mole fraction of acetone in vapour";
parameter Real Pd(unit = "kPa") = 65 "Pressure";

//=============
//Variable Section
Real Td(unit = "K") "Equilibrium temperature";
Real P1s_d(unit = "kPa") "Vapour pressure of acetone at 334 K";
Real P2s_d(unit = "kPa") "Vapour pressure of acetonitrile at 334 K";
Real x1d(unit = "-") "Mole fraction of acetone in liquid";

//============
//Equation Section
equation 
Td = 334;   //Equilibrium temperature from trials
log(P1s_d) = A1-(B1/(Td-C1));    //Antoine equation
log(P2s_d) = A2-(B2/(Td-C2));    //Antoine equation
x1d = (y1d*Pd)/(P1s_d);   //From Eqn.8.54 pg no.353

end Ex8_9_d;
 
//=============

model Ex8_9_e

extends Ex8_9_a;

//=============
//Parameter Section
parameter Real y1e(unit = "-") = 0.4 "Mole fraction of acetone in vapour";
parameter Real Te(unit = "K") = 327 "Temperature";

//============
//Variable Section
Real Pe(unit = "kPa") "Equilibrium pressure";
Real x1e(unit = "-") "Mole fraction of acetone in liquid";

//============
//Equation Section
equation 
x1e = (y1e*P2s_a)/(P1s_a-(y1e*(P1s_a-P2s_a)));
Pe = (x1e*P1s_a)/y1e;   //From Eqn.8.54 pg no.353

end Ex8_9_e;

//============

model Ex8_9_f

extends Ex8_9_a;

//============
//Parameter Section
parameter Real z(unit = "%") = 70 "Overall composition acetone in the system";

//============
//Variable Section
Real L(unit = "mol") "Moles of system that is liquid";
Real f(unit = "%") "Fraction of system that is liquid";
Real F(unit = "mol") "Composition of feed";

//===========
//Equation Section
equation
F = 1;    ///Basis
(F*(z/100)) = (L*x1a)+((1-L)*y1a);
f = L*100;

end Ex8_9_f;

//=============
end Ex8_9;
