//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 9: Chemical Reaction Equilibria
//Example: 9.10 Page 444
//Title: Evaluation of equilibrium constant
//===================================================

model Ex9_10

//CO(g) + 2H2(g) ----> CH3OH(g)

//============
//Parameter Section
parameter Real T(unit = "K") = 600 "Temperature";
parameter Real a(unit = "-") = 1 "Stoichiometric coefficient of CO";
parameter Real b(unit = "-") = 2 "Stoichiometric coefficient of H2";
parameter Real c(unit = "-") = 1 "Stoichiometric coefficient of CH3OH";
parameter Real phi1(unit = "J/mol K") = -203.81 "Gibbs energy function of CO";
parameter Real phi2(unit = "J/mol K") = -136.39 "Gibbs energy funcion of H2";
parameter Real phi3(unit = "J/mol K") = -249.83 "Gibbs energy funcion of CH3OH";
parameter Real delta_H1(unit = "J/mol") = -110500 "Heat of formation of CO";
parameter Real delta_H3(unit = "J/mol") = -200700 "Heat of formation of CH3OH";
parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";

//============
//Variable Section
Real delta_G(unit = "J/mol") "Standard free energy of formation at 600 K";
Real K(unit = "-") "Equilibrium constant at 600 K";

//============
//Equation Section
equation
delta_G/T=((c*phi3)-(a*phi1)-(b*phi2))+(((c*delta_H3)-(a*delta_H1))/T);   //Using Eqn. 9.57 pg no. 443
-(R*log(K)) = delta_G/T;    //Using Eqn. 9.31 pg no. 433

end Ex9_10;

//===================================================
