//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 9: Chemical Reaction Equilibria
//Example: 9.16 Page 452
//Title: Conversion of nitrogen in presence of argon
//================================================

model Ex9_16

//N2+3H2 ----> 2NH3

//=============
//Parameter Section
parameter Real n_N2(unit = "mol") = 1 "Mole of nitrogen in reactant"; 
parameter Real n_H2(unit = "mol") = 3 "Moles of hydrogen in reactant";
parameter Real n_Ar(unit = "mol") = 2 "Moles of Argon in reactant";
parameter Real K(unit = "-") = 2/10^4 "Equilibrium constant";
parameter Real T(unit = "K")  = 675 "Temperature";
parameter Real P(unit = "bar") = 20 "Pressure";
parameter Real a(unit = "-") = 1 "Stoichiometric coefficient of N2";
parameter Real b(unit = "-") = 3 "Stoichiometric coefficient of H2";
parameter Real c(unit = "-") = 2 "Stoichiometric coefficient of NH3";


//============
//Variable Section
Real n(unit = "mol") "Total moles";
Real nu(unit = "-") "Sum of stoichiometric numbers";
Real K_phi(unit = "-") "Equilibrium constant in terms of fugaciy coefficient";
Real Ky(unit = "-") "Equilibrium constant in terms composition";
Real epsilon(unit = "-") "Extent of the reaction";
Real z(unit = "%") "Percentage conversion of nitrogen";


//=============
//Equation Section
equation
n = n_N2+n_H2+n_Ar;
nu = c-a-b;
K_phi = 1;    //Ideal behaviour is assumed
Ky = (K/K_phi)*(1/P^nu);
((c*epsilon)^c*(n+(nu*epsilon))^(-nu))/((n_N2-(a*epsilon))^a*(n_H2-(b*epsilon))^b)= Ky;
z = (a*epsilon)/n_N2*100;

end Ex9_16;

//================================================
