//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 9: Chemical Reaction Equilibria
//Example: 9.17 Page 453
//Title: Partial pressure of species and conversion of oxygen
//================================================

model Ex9_17

//N2+O2 = 2NO

//============
//Parameter Section
parameter Real a(unit = "-") = 1 "Stoichiometric coefficient of nitrogen";
parameter Real b(unit = "-") = 1 "Stoichiometric coefficient of oxygen";
parameter Real c(unit = "-") = 2 "Stoichiometric coefficient of nitrogen oxide";
parameter Real T(unit = "K")  = 2975 "Temperature";
parameter Real P(unit = "kPa") = 2025 "Pressure";
parameter Real n_O2(unit = "%") = 15 "Mole percent of oxygen";
parameter Real n_N2(unit = "%") = 77 "Mole percent of nitrogen";
parameter Real delta_G(unit = "kJ/mol") = 113.83 "Standard Gibbs free energy change for the reaction";
parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";

//============
//Variable Section
Real n(unit = "mol") "Total moles";
Real n_i(unit = "%") "Mole percent of inerts";
Real nu(unit = "-") "Sum of stoichiometric numbers";
Real K(unit = "-") "Equilibrium constant";
Real Ky(unit = "-") "Equilibrium constant in terms composition";
Real epsilon1(unit = "-") "Extent of the reaction";
Real p_N2(unit = "kPa") "Partial pressure of nitrogen";
Real p_O2(unit = "kPa") "Partial pressure of oxygen";
Real p_NO(unit = "kPa") "Partial pressure of nitrogen oxide";
Real p_i(unit = "kPa") "Partial pressure of inerts";
Real epsilon2(unit = "-") "Extent of reaction in absence of inerts";
Real z(unit = "%") "Percentage conversion of oxygen";


//=============
//Equation Section
equation
n_i = 100-n_N2-n_O2;
n = n_N2+n_O2+n_i;
nu = c-a-b;
K = exp(-(delta_G*1000)/(R*T));   //Convering kJ to J
K = Ky*P^nu;
Ky = ((c*epsilon1)^c*(n+(nu*epsilon1))^(-nu))/((n_N2-(a*epsilon1))^a*(n_O2-(b*epsilon1))^b);
p_O2 = ((n_O2-(a*epsilon1))/100)*P;   //Mole fraction is multiplied by total pressure
p_N2 = ((n_N2-(b*epsilon1))/100)*P;
p_NO = ((c*epsilon1)/100)*P;
p_i = (n_i/100)*P;
Ky = ((c*epsilon2)^c*(n+(nu*epsilon2))^(-nu))/((n_N2-(a*epsilon2))^a*(n_O2-(b*epsilon2))^b);
z = (b*epsilon2)/n_O2*100;

end Ex9_17;

//Inerts will not influence conversion

//================================================
