//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 9: Chemical Reaction Equilibria
//Example: 9.21 Page 457
//Title: Percent conversion of carbon monoxide in presence of inerts
//================================================

model Ex9_21

//CO(g)+2H2(g) ----> CH3OH(g)

//============
//Parameter Section
parameter Real pa(unit = "%") = 25 "Moles of carbon monoxide";
parameter Real pb(unit = "%") = 55 "Moles of hydrogen";
parameter Real pd(unit = "%") = 20 "Moles of inerts";
parameter Real a(unit = "-") = 1 "Stoichiometric coefficient of CO";
parameter Real b(unit = "-") = 2 "Stoichiometric coefficient of H2O";
parameter Real c(unit = "-") = 1 "Stoichiometric coefficient of CO2";
parameter Real T(unit = "K")  = 625 "Temperature";
parameter Real P(unit = "bar") = 300 "Pressure";
parameter Real Kf(unit = "-") = 4.9/10^5 "Equilibrium constant in terms of fugacity";
parameter Real Kphi(unit = "-") = 0.35 "Equilibrium constant in terms of fugacity coefficient";

//============
//Variable Section
Real n(unit = "mol") "Moles of initial gas mixture";
Real na(unit = "mol") "Moles of carbon monoxide";
Real nb(unit = "mol") "Moles of hydrogen";
Real nd(unit = "mol") "Moles of inerts";
Real nu(unit = "-") "Sum of stoichiometric coefficients";
Real Ky(unit = "-") "Equilibrium constant in terms of composition";
Real epsilon(unit = "-") "Extent of reaction ";
Real z(unit = "%") "Percentage conversion of CO";

//============
//Equation Section
equation
n = 100;    //Basis
na = (pa/100)*n; 
nb = (pb/100)*n; 
nd = (pd/100)*n; 
nu = c-a-b;
Ky = (Kf/Kphi)*(1/P^nu);    //K=Kf for gases
Ky = ((c*epsilon)^c*(n+(nu*epsilon))^(-nu))/((na-(a*epsilon))^a*(nb-(b*epsilon))^b);
z = (a*epsilon)/na*100;

end Ex9_21;

//================================================
