//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 9: Chemical Reaction Equilibria
//Example: 9.25 Page 464
//Title: Calculation of Gibbs free energy, enthalpy and entropy
//================================================

model Ex9_25

//============
//Parameter Section
parameter Real T(unit = "K") = 675 "Temperature ";
parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";

//============
//Variable Section
Real K(unit = "-") "Equilibrium constant";
Real delta_G(unit = "kJ") "Gibbs free energy";
Real delta_H(unit = "kJ") "Standard heat of reaction";
Real delta_S(unit = "kJ/K") "Standard entropy of reaction";

//============
//Equation Section
equation
//ln(P) = 14.4-(9600/T)
log(K) = 14.4-(9600/T);      //K=p_CO
delta_G = -(R*T*log(K));   //Using Eqn. 9.31 p.433
delta_H = 9600*R;    // Using Eqn. 9.36  p.437
delta_S = (delta_H-delta_G)/T;

end Ex9_25;

//================================================
