//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 9: Chemical Reaction Equilibria
//Example: 9.6 Page 442
//Title: Calculation of equilibrium constant
//===================================================

model Ex9_6

//============
//Parameter Section
parameter Real T(unit = "K") = 298 "Temperature";
parameter Real delta_G1(unit = "J/mol") = 97540 "Standard free energy of formation of N2O4";
parameter Real delta_G2(unit = "J/mol") = 51310 "Standard free energy of formation of NO2";
parameter Real a(unit = "-") = 1 "Stoichiometric coefficient of N2O4";
parameter Real b(unit = "-") = 2 "Stoichiometric coefficient of NO2";
parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";

//============
//Variable Section
Real delta_G(unit = "J/mol") "Standard free energy of reaction";
Real K(unit = "-") "Equilibrium constant";

//============
//Equation Section
equation
//N2O4(g) ----> 2NO2(g)
delta_G = (b*delta_G2)-(a*delta_G1);    //From Eqn. 9.50 p 440
delta_G = -R*T*log(K);      //From Eqn. 9.31 p 433

end Ex9_6;

//===================================================
