//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 9: Chemical Reaction Equilibria
//Example: 9.8 Page 443
//Title: Standard free energy of reaction
//===================================================

model Ex9_8

//============
//Parameter Section
parameter Real T2(unit = "K") = 317 "Temperature 1";
parameter Real T1(unit = "K") = 391 "Temperature 2";
parameter Real y_nb2(unit = "%") = 31 "Mole % of n-butane at 317 K";
parameter Real y_nb1(unit = "%") = 43 "Mole % of n-butane at 391 K";
parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";

//============
//Variable Section
Real y_ib2(unit = "%") "Mole % of i-butane at 317 K";
Real y_ib1(unit = "%") "Mole % of i-butane at 391 K";
Real K2(unit = "-") "Equilibrium constant at 317 K";
Real K1(unit = "-") "Equilibrium constant at 391 K";
Real delta_G2(unit = "J/mol") "Free energy of reaction at 317 K";
Real delta_G1(unit = "J/mol") "Free energy of reaction at 391 K";
Real delta_H(unit = "J/mol") "Average enthalpy of reaction";

//============
//Equation Section
equation
y_ib2 = 100-y_nb2;
y_ib1 = 100-y_nb1;
K2 = y_ib2/y_nb2;   //Activities are equal to the mole fractions
K1 = y_ib1/y_nb1;
delta_G2 = -R*T2*log(K2);   //From Eqn.9.31 pg no. 433
delta_G1 = -R*T1*log(K1);
log(K2/K1) = -(delta_H/R)*(1/T2-1/T1);    //From Eqn. 9.37 pg no.438

end Ex9_8;

//===================================================

