//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 9: Chemical Reaction Equilibria
//Example: 9.9 Page 444
//Title: Standard free energy of reaction
//===================================================

model Ex9_9

//N2(g)+3H2(g)  ----> 2NH3(g)

//============
//Parameter Section
parameter Real T1(unit = "K") = 700 "Temperature";
parameter Real T(unit = "K") = 298 "Standard temperature";
parameter Real a(unit = "-") = 1 "Stoichiometric coefficient of N2";
parameter Real b(unit = "-") = 3 "Stoichiometric coefficient of H2";
parameter Real c(unit = "-") = 2 "Stoichiometric coefficient of NH3";
parameter Real alpha[3] = {27.27,27.01,29.75} "alpha in Cp equation for N2, H2 and NH3";
parameter Real beta[3] = {(4.93/10^3),(3.51/10^3),(25.11/10^3)} "beta in Cp equation for N2, H2 and NH3";
parameter Real delta_H3(unit = "J/mol") = -46100 "Standard heat of formation of ammonia at 298 K";
parameter Real delta_G3(unit = "J/mol") = -16500 "Standard free energy of formation of ammonia at 298 K";
parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";

//============
//Variable Section
Real delta_G(unit = "J/mol") "Standard free energy of reaction";
Real delta_H(unit = "J/mol") "Standard heat of reaction";
Real del_alpha(unit = "-") "Change of specific heat coefficient-alpha";
Real del_beta(unit = "-") "Change of specific heat coefficient-beta";
Real delta_Ho(unit = "-") "Constant";
Real A(unit = "-") "Constant of intergration";
Real K(unit = "-") "Eqilibrium constant at 700 K";
Real delta_G1(unit = "J/mol") "Standard free energy of reaction at 700 K";

//============
//Equation Section
equation
delta_G = (c*delta_G3);    //From Eqn. 9.50 Pg no. 440
delta_H = c*delta_H3;     
del_alpha = (c*alpha[3])-(a*alpha[1])-(b*alpha[2]);
del_beta = (c*beta[3])-(a*beta[1])-(b*beta[2]);
delta_H = delta_Ho+(del_alpha*T)+((del_beta/2)*T^2);    //Using Eqn. 9.46 pg no. 439
delta_G = delta_Ho-(del_alpha*T*log(T))-(del_beta/2*T^2)-(A*R*T); //Using Eqn. 9.48  pg no. 440
log(K) = -(delta_Ho/(R*T1))+((del_alpha/R)*log(T1))+((del_beta/(2*R))*T1)+A;    // Using Eqn. 9.47  pg no. 439
delta_G1 = delta_Ho-(del_alpha*T1*log(T1))-(del_beta/2*T1^2)-(A*R*T1);    //Using Eqn. 9.48 

end Ex9_9;

//===================================================
