class Ex13_1_9
/* Page 731*/
  parameter Real Ma(unit="kg/m3")=250;
  parameter Real Me(unit="kg/m3")=500;
  parameter Real mma(unit="g/mol")=60;  
  parameter Real mme(unit="g/mol")=46;  
  parameter Real mmw(unit="g/mol")=18;  
  parameter Real rho(unit="kg/m3") =1040;  
  parameter Real K=2.92;
  Real X;
  Real Ca(unit="kmol/m3");
  Real Ce(unit="kmol/m3");
  Real Cw(unit="kmol/m3");
  Real Can(unit="kmol/m3");
  Real Cen(unit="kmol/m3");
  Real Cwn(unit="kmol/m3");
  Real Cea(unit="kmol/m3");
  Real Knew;
equation
  Ca=Ma/mma;
  Ce=Me/mme;
  Cw=(rho-Me-Ma)/mmw;
  K=(Cw+X)*X/((Ce-X)*(Ca-X));
  Can=Ca-X;
  Cen=Ce-X;
  Cwn=Cw+X;
  Cea=X;
  Knew=Cw*Cea/(Cen*Can);
end Ex13_1_9;