class Ex4_5_5
  /* Page 133*/
  parameter Real T1(unit = "'C") = 100;
  parameter Real T2(unit = "'C") = 100;
  parameter Real P1(unit = "bar") = 0.9;
  parameter Real P2(unit = "bar") = 0.1;
  parameter Real P(unit = "bar") = 2;
  parameter Real V(unit = "m3") = 3;
  parameter Real T(unit = "K") = 373.15;
  parameter Real R(unit = "bar m3/ mol K") = 0.08314;
    
  /*Total Mass:   N=N1+N2
  Total Energy: U=U1+U2
  Total Entropy:S=S1+S2
  N(1)i=PV/RT*/
  Real N1i(unit = "kmol");
  Real N1(unit = "mol");
  Real N2(unit = "mol");
  parameter Real Pf(unit = "mol") = 1.9;
  parameter Real Pi(unit = "mol") = 0.1;
  Real term1;
  Real term2;
  Real dS;
  //Sf-Si=-R*log(Pf/Pi)
equation
  N1i=P*V/(R*T);
  N1=0.95*N1i;
  N2=0.05*N1i;
//term1=dS/(N1i*R)
  dS=-N1i*R*( 0.95*log(Pf/2) + 0.05*log(Pi/2) );
  term1 = -(Pf/2)* log(Pf/2) - (Pi/2) * log(Pi/2);
//dS/(N1i*R)=0.199
//term2=dS/(N1f*R)
  term2 = -P1 * log(P1) -P2 * log(P2);
//dS/(N1f*R)=0.325
end Ex4_5_5;