class Ex5_3_3
  /* Page 177*/
  parameter Real Tf(unit = "'C") = 212.42;
  parameter Real ViL(unit = "m3/kg") = 0.001177;
  parameter Real UiL(unit = "kJ/kg") = 906.44;
  parameter Real UV(unit = "kJ/kg") = 2506.1;
  parameter Real UL(unit = "kJ/kg") = 417.36;
  parameter Real SiL(unit = "kJ/kgK") = 2.4474;
  parameter Real SV(unit = "kJ/kgK") = 7.3594;
  parameter Real SL(unit = "kJ/kgK") = 1.3026;
  parameter Real Vt(unit = "m3") = 0.197;
  Real M(unit = "kg");
  Real wf;
  Real W(unit = "kJ");
equation
  M = Vt / ViL;
  wf = (SiL - SL) / (SV - SL);
  W = M * (UiL - (wf * UV + UL * (1 - wf)));
end Ex5_3_3;