class Ex5_3_4
  /* Page 177*/
  parameter Real Tf(unit = "K") = 212.42 + 273.15;
  parameter Real Tb(unit = "K") = 100 + 273.15;
  parameter Real R = 8.314;
  parameter Real MM = 18;
  parameter Real dHvap(unit = "kJ/kg") = 2250;
  parameter Real CpL(unit = "J/gK") = 4.184;
  parameter Real M(unit = "kg") = 167.5;
  Real wf;
  Real W(unit = "kJ");
equation
  wf = 1 - exp(CpL * (Tb - Tf) / dHvap);
  W = M * (CpL * (Tf - Tb) - wf * (dHvap - R * Tb / MM));
end Ex5_3_4;