class Ex7_4_8
  /* Page 304*/
  parameter Real V(unit = "m3/mol") = 1.969 * 10 ^ (-5);
  parameter Real P(unit = "MPa") = 0.4 * 0.001;
  parameter Real R = 8.314;
  parameter Real T = 268.15;
  Real fice1(unit = "kPa");
  Real fice10(unit = "kPa");
  Real fic100(unit = "kPa");
equation
  fice1 = 1000 * P * exp(V * (0.1 - P) / (R * T * 10 ^ (-6)));
  fice10 = 1000 * P * exp(V * (10 - P) / (R * T * 10 ^ (-6)));
  fic100 = 1000 * P * exp(V * (100 - P) / (R * T * 10 ^ (-6)));
end Ex7_4_8;