// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn., Prentice-Hall International

//Chapter-1: Introduction to Engineering principles and units 
//Example 1.5-3 Page 12
// Title: Combustion of flue gases

//=======================================================
// Chemical Reaction
// CO + 0.5O2 ---> CO2 ---> (1)
// H2 + 0.5O2 ---> H20 ---> (2)
//========================================================
model Ex1_5_3

//==================
//Parameter section
parameter Real mH2(unit = "moles")=3.1 "Moles of H2";
parameter Real mCO(unit = "moles")=27.2 "Moles of CO";
parameter Real mCO2(unit = "moles")=5.6 "Moles of CO2";
parameter Real mO2(unit = "moles")=0.5 "Moles of O2";
parameter Real mN2(unit = "moles")=63.6 "Moles of N2";
parameter Real exO2(unit = "-")=0.2 "Excess O2 %";
  // NOTE : The feed is 100 moles. So the composition of corresponding compounds are multiplied with 100

//==================
//Variable section
Real nH2O(unit = "moles") "Moles of H2O";
Real nCO(unit = "moles")"Moles of CO";
Real nCO2(unit = "moles")"Moles of CO2";
Real nO2(unit = "moles") "Moles of O2";
Real nN2(unit = "moles") "Moles of N2";
Real O2reqd(unit = "moles") "O2 Required for complete reaction";
Real O2supp(unit = "moles") "O2 supplied for reaction";
Real O21(unit = "moles") "O2 used for reaction----> (1)";
Real O22(unit = "moles") "O2 used for reaction ----> (2)";

//===================
//Equation section
equation
nH2O = (1/1)*mH2; // Moles of H2O at the exit. where 1 is the stochiometric coefficient of H2&H2O
O22 = (0.5/1)*nH2O; // Moles of O2 used in second rxn. where 0.5 and 1 are stochiometric coeffecient";
nCO2 = 0.98*mCO; // Moles of CO2 at exit";
nCO = 0.02*mCO; // Moles of CO at exit";
O21 = (0.5/1)*nCO2; // Moles of O2 used in first rxn";
O2reqd = O21 + O22; // Moles of O2 reacted in both reactions";
O2supp/O2reqd = 1 + exO2; // O2 supplied in 20% excess air";
nO2 = O2supp - O2reqd; // Moles of O2 at exit";
nN2 = mN2 + O2supp*(79/21); // Moles of N2 at Exit";
end Ex1_5_3;
//==========================================================
