// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn., Prentice-Hall International

//Chapter-1: Introduction to Engineering principles and units 
//Example 1.6-1 Page 14
// Title: Heating of N2 gas
//==================================================
model Ex1_6_1

//================
//Parameter section
parameter Real deltaT1(unit = "K")=(673-298)"1st temp range";
parameter Real deltaT2(unit = "K")=(1123-298) "2nd temp range";
parameter Real cpm1(unit = "J/mol.K")=29.68 "Specific heat capacity ---> 1";
parameter Real cpm2(unit = "J/mol.K")=31 "Specific heat capacity ----> 2";
parameter Real M(unit = "gmol")=3 "Moles of N2";


//================
//Variable section
Real Q1(unit = "Joule") "Heat obtained by heating in respective temp range";
Real Q2(unit = "Joule") "Heat obtained by heating in respective temp range";
Real Q3(unit = "Joule") "Difference between Q1 and Q2";

//================
//Equation section
equation
Q1 = M*cpm1*deltaT1; // Heat required for delT1";
Q2 = M*cpm2*deltaT2; // Heat required for delT2";
Q3 = Q2 - Q1; // Difference between  Q2&Q3";
  // Note: // specific heat values are taken from table 1.6-1, page : 15
end Ex1_6_1;
//==================================================
