// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-1: Introduction to Engineering principles and units
//Example 1.6-3 Page 17
// Title: Use of steam tables
// ================================================
package Ex1_6_3
     
model Ex1_6_3_A

//================
//Parameter section
parameter Real H1(unit = "kJ/kg") = 88.6 "Enthalpy at 21 C";
parameter Real H2(unit = "kJ/kg") = 251.13 "Enthalpy at 60 C";

// Enthalpy of the liquid is taken from appendix A.2
 
//===============
//Variable section
Real deltaH(unit = "kJ/kg")"Change in Enthalpy";

//================
//Equation section
equation
deltaH = H2 - H1 "Change in enthalpy";
end Ex1_6_3_A;
//=================================================

//=================================================
model Ex1_6_3_B
  
//=================
//Parameter section
parameter Real H1(unit = "kJ/kg") = 88.6 "Enthalpy at 21 C";
parameter Real H2(unit = "kJ/kg") = 2699.9" Enthalpy at 115.6 C";

// Enthalpy of the liquid is taken from appendix A.2
 
//=================
//Variabe section
Real deltaH(unit = "kJ/kg") "Change in enthalpy";

//=================
//Equation section
equation
deltaH = H2 - H1 "Change in enthalpy";
end Ex1_6_3_B;
//===================================================

//===================================================
model Ex1_6_3_C

//================
//Parameter section
parameter Real H1(unit = "kJ/kg") = 484.9 "Enthalpy at 100 C";
parameter Real H2(unit = "kJ/kg") = 2699.9 "Enthalpy at 115.6 C";

// Enthalpy of the liquid is taken from appendix A.2
    
//================
//Variable section
Real deltaH(unit = "kJ/kg") "Change in enthalpy";

//================  
//Equation section
equation
deltaH = H2 - H1 "Change in enthalpy";
end Ex1_6_3_C;
//==================================================
end Ex1_6_3;
//=====================================================
