// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-1: Introduction to Engineering principles and units 
//Example 1.6-4 Page 18
// Title: Combustion of carbon
//=============================================================
model Ex1_6_4

//===============================
//Parameter section
// All heat of combustion values are taken from Appendix A.3
parameter Real deltaHCO2_SI(unit = "kJ/kmol")= -393.513 "Heat of combustion of CO2";
parameter Real deltaHCO_SI(unit = "kJ/kmol") = -110.523 "Heat of combustion of CO";
parameter Real deltaHCO2_cgs(unit = "kcal/gmol")= -94.0518 "Heat of combustion of CO2";
parameter Real deltaHCO_cgs(unit = "kcal/gmol") = -26.4157 "Heat of combustion of CO";
parameter Real nC(unit = "moles")=10 "Total input moles";

//Reaction : CO + (1/2)O2 ---> CO2

//===============================
//Variable section
Real deltaH_SI(unit = "kJ/kmol") "Heat of Reaction";
Real deltaH_cgs(unit = "kcal/gmol") "Heat of Reaction";
Real nCO2(unit = "moles") "Moles of CO2";
Real nCO(unit = "moles")"Moles of CO";

//================================
//Equation section
equation
nCO2 = nC*0.9; // Moles of CO2";
 // 90% of the reaction is completed as per question
nCO = nC*0.1; // Moles of CO";
 // 10% of the reaction is incomplete as per question
deltaH_SI = nCO2*deltaHCO2_SI + nCO*deltaHCO_SI; //Heat of reaction
deltaH_cgs = nCO2*deltaHCO2_cgs + nCO*deltaHCO_cgs; //Heat of reaction
end Ex1_6_4;
//======================================================================
