//C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-1: Introduction to Engineering principles and units 
//Example 1.6-5 Page 18
// Title: Reaction of Methane
//===========================================================
model Ex1_6_5

//============================
//Parameter section
parameter Real deltaHCH4(unit = "kJ/kmol") = -74.848*10^3 "Heat of formation of CH4";
parameter Real deltaHH2O(unit = "kJ/kmol") = -285.840*10^3 "Heat of formation of H2O";
parameter Real deltaHCO(unit = "kJ/kmol") = -110.523*10^3  "Heat of formation of CO";
parameter Real deltaHH2(unit = "kJ/kmol") = 0  "Heat of formation of H2";

//Reaction : CH4 + H2O ----> CO + 3H2

//==============================
//Variable section
Real deltaH(unit = "kJ/kmol") "Heat of Reaction";

//=============================
//Equation section
equation
// According to stochiometry of the above reaction
deltaH = 1*deltaHCO + 3*deltaHH2 - 1*deltaHCH4 - 1*deltaHH2O; // Heat of reaction
if deltaH > 0 then Modelica.Utilities.Streams.print("Endothermic"); // Decision making statements
end if;
if deltaH < 0 then Modelica.Utilities.Streams.print("Exothermic");
end if;
end Ex1_6_5;
//===========================================================
