// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-1: Introduction to Engineering principles and units 
//Example 1.7-3 Page 22
// Title: Oxidation of lactose
// ======================================================
model Ex1_7_3

//==================
//Parameter section
parameter Real CPL(unit = "J/g.K")=1.2 "Mean specific heat of lactose";
parameter Real CPO2(unit = "J/mol.K")=29.38 "Mean specific heat of O2";
parameter Real CPCO2(unit = "J/mol.K")=37.45 "Mean specific heat of CO2";
parameter Real CPH2O(unit = "J/g.K")=4.18 "Mean specific heat of H2O";
parameter Real nL(unit = "moles")=1 "Moles of lactose";
parameter Real nO2(unit = "moles")=12 "Moles of O2";
parameter Real nCO2(unit = "moles")=12 "Moles of CO2";
parameter Real nH2O(unit = "moles")=11 "Moles of H2O";
parameter Real T(unit = "C")= 37 "Temperature specified in the problem";
parameter Real Tr(unit = "C")=25 "Reference temperature";
parameter Real deltaH25(unit = "J/mol")= - 5648.8*10^3 "Heat of combustion at 25 C";

// Heat of combustion at 25 c is taken from appendix A.3

//==================
//Variable section
Real HL(unit = "J") "Heat of Lactose";
Real HO2(unit = "J") "Heat of O2"; 
Real HCO2(unit = "J") "Heat of CO2";
Real HH2O(unit = "J") "Heat of H20";
Real deltaH37(unit = "J/mol") "Heat of combustion at 37 C";

//==================
//Equation section
equation
HL = 343.3*nL*CPL*(T - Tr) "Enthlpy change of lactose";
HO2 = nCO2*CPO2*(T - Tr)"Enthalpy change of O2";
HCO2 = nCO2*CPCO2*(T - Tr)"Enthalpy change of CO2";
HH2O = 18*nH2O*CPH2O*(T - Tr) "Enthalpy change of H2O";

//==================
//Energy balance
HL + HO2 = HCO2 + HH2O + deltaH25 - deltaH37 "Energy balance equation" ;
end Ex1_7_3;
//===========================================================
