// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-10 Stage and continuous gas-liquid separation processes
//Example 10_3_2 Page:591
//Title: Absorption of acetone in a counter current stage tower
//================================================
model Ex10_3_2

//=================
//Paramter section
parameter Real Lo(unit = "kmol/hr") = 90 "Liquid incoming flow rate";
parameter Real VN(unit = "kmol/hr") = 30 "Vapor incoming flow rate";
parameter Real H(unit = "atm/mol.frac") = 0.142E+04 "Henry s law constant";
parameter Real yaN(unit = "-") = 0.01 "Mole fraction of inlet gas stream";
parameter Real xao(unit = "-") = 0 "Mole fraction of inlet liquid stream";

//=================
//Variable section
Real xaN(unit = "-") "Mole fraction of solute in liquid";
Real ya1(unit = "-") "Mole fraction of solute in vapor";
Real LN(unit = "kmol/h") "Molar flow rate of liquid leaving";
Real V1(unit = "kmol/h") "Molar flow rate of vapor leaving";
Real V_air(unit = "kmol/h") "Molar flow rate of inert";
Real V_act(unit = "kmol/h") "Molar flow rate of acetone";

//=================
//Eqution section
equation
V_air = VN*(1-yaN) ; // Flow rate of inert
V_act = VN*yaN ; // Flow rate of solute
V1 = V_air + 0.10*V_act ; // Flow rate of vapor coming out
LN = Lo + 0.9*V_act ; // Flow rate of liquid leaving
ya1 = 0.10*V_act/V1 ; // Mole fraction of vapor leaving
xaN = 0.9*V_act/LN ; // Mole fraction of liquid leaving
// A graph is plotted and number of stages in 5
end Ex10_3_2;
//========================================================
