// C.J. Geankopolis, Transport processs and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-10 Stage and continuous gas-liquid separation processes
//Example 10_8_1 Page:633
//Title: Prediction of film coeficient for ammonia absorption
//================================================
model Ex10_8_1

//================
//Parameter section
parameter Real m(unit = "-") = 1.20 "Slope of equilibrium line";
parameter Real mu_air(unit = "Pa.s") = 1.86E-05 "Viscosity of air";
parameter Real rho_air(unit = "kg/m^3") = 1.168 "Density of air";
parameter Real Da_air(unit = "m^2/s") = 2.379E-05 "Diffusivity of NH3 at 303K";
parameter Real Da_water(unit = "m^2/s") = 2.652E-09 "Diffisivity of water at 303K";
parameter Real mu_water(unit = "Pa.s") = 0.8007E-03 "Viscosity of water";
parameter Real rho_water(unit = "kg/m^3") = 996 "Density of water";
parameter Real Gx(unit = "kg/m^2.s") = 2.543 "Flow rate of liquid";
parameter Real Gy(unit = "kg/m^2.s") = 0.339 "Flow rate of vapor";
parameter Real alpha(unit = "-") = 0.557 "Packing parameter";
parameter Real beta(unit = "-") = 0.32 "Packing parameter";
parameter Real gamma(unit = "-") = -0.51 "Packing parameter";
parameter Real eta(unit = "-") = 0.22 "Packing parameter";
parameter Real teta(unit = "-") = 2.35E-03 "Packing parameter";
parameter Real Ma(unit = "kg/kmol") = 29 "Molecular weight of air";
parameter Real Mb(unit = "kg/kmo") = 18 "Molecular weight of water";

//================
//Variable section
Real Nsc1(unit = "-") "Schmid number for case 1";
Real Hg(unit = "m") "Gas phase height of transfer units";
Real Nsc2(unit = "-") "Schmid number for case 2";
Real Hl(unit = "m") "Liquid phase height of transfer units";
Real ky(unit = "kmol/m^3.s.molfrac") "Gas phase mass transfer coefficient";
Real kx(unit = "kmol/m^3.s.molfrac") "Liquid phase mass transfer coefficient";
Real Ky(unit = "kmol/m^3.s.molfrac") "Overall gas phase mass transfer coefficient";

//================
//Equation section
equation
Nsc1 = mu_air/(rho_air*Da_air) ; // Schmit number
Hg = alpha*Gy^beta*Gx^gamma*Nsc1^0.5 ; // Height of tramsfer units
Nsc2 = mu_water/(rho_water*Da_water) ; // Schmit number
Hl = teta*(Gx/mu_water)^eta*Nsc2^0.5 ; // Schmit number 
ky = Gy/Ma/Hg ; // Gas phase mass transfer coefficient
kx = Gx/Mb/Hl ; // Liquid phase mass transfer coefficient
1/Ky = 1/ky + m/kx ; // Overall mass transfer coefficient
end Ex10_8_1;
//=============================================================
