// C.J. Geankopolis, Transport processs and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-11 Vapor liquid separation processes
//Example 11_4_1 Page:656
//Title: Rectification of banzene toluene mixture 
//================================================
model Ex11_4_1

//================
//Parameter section
parameter Real F(unit = "kmol/hr") = 100 "Feed mole flow rate";
parameter Real xf(unit = "-") = 0.45 "Mole fraction of MVC in feed";
parameter Real xd(unit = "-") = 0.95 "Mole fraction of distillate";
parameter Real xw(unit = "-") = 0.10 "Mole fracion of bottom";
parameter Real cp(unit = "kJ/kmol.K") = 159 "Specific heat capacity";
parameter Real lamda(unit = "kJ/kmol") = 32099 "Latent heat of vaporisation";
parameter Real Tf(unit = "K") = 327.6 "Feed temperature";
parameter Real Tb(unit = "K") = 366.7 "Boiling point of feed";

//================
//Variable section
Real D(unit = "kmol/hr") "Distillate flow rate";
Real W(unit = "kmol/hr") "Bottom flow rate";
Real q(unit = "-") "Thermal condition of feed";
Real slope(unit = "-") "Condition of feed";

//=================
//Equation section
equation
F = D + W; // Overall mass balance
F*xf = D*xd + W*xw ; // Component balance
q = (lamda + cp*(Tb-Tf))/lamda ; // Thermal condition of feed
slope = q/(q-1) ; // Condition of feed
 // The stripping operating line is drawn connecting xw with intersection of q line and enriching operating line and number of trays are obtained
end Ex11_4_1;
//==================================================
