// C.J. Geankopolis, Transport processs and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-11 Vapor liquid separation processes
//Example 11_6_1 Page:670
//Title: Enthalpy concentration plot for benzene and toluene  
//================================================
model Ex11_6_1

//==================
//Parameter section
parameter Real TbA(unit = "K") = 80.1 "Boiling point of benzene";
parameter Real TbB(unit = "K") = 110.6 "Boiling point of toluene";
parameter Real CpA_L(unit = "kJ/kmol.K") = 138.2 "Specific heat capacity of liq of A";
parameter Real CpA_V(unit = "kJ/kmol.K") = 96.3 "Specific heat capacity of vap of A";
parameter Real CpB_L(unit = "kJ/kmol.K") = 167.5 "Specific heat capacity of liq of B";
parameter Real CpB_V(unit = "kJ/kmol.K") = 138.2 "Specific heat capacity of vap of B";
parameter Real L_A(unit = "kJ/kmol.K") = 30820 "Latent heat of vap of A";
parameter Real L_B(unit = "kJ/kmol.K") = 33330 "Latent heat of vap of B";

//==================
//Variable section
Real h(unit = "kJ/kmol")  "Zero heat of solution";
Real To(unit = "K") "Reference temperature";
Real lamda_B(unit = "kJ/kmol") "Latent heat of vaporisation of B";
Real H(unit = "kJ/kmol") "Total enthalpy of solution";
Real Hvap(unit = "kJ/kmol") "Saturated vapor enthalpy";
Real hliq(unit = "kJ/kmol") "Saturated liquid enthalpy";
Real Hvap1(unit = "kJ/kmol") "Saturated vapor enthalpy";

//==================
//Equation section
equation
 // For pure benzene and toluene xa = 0 ; xb = 1
To = TbA ; // Reference temperature
h = 0*CpA_L*(TbA - To) + 1*CpB_L*(TbB - To) ; // zero heat of solution
lamda_B = CpB_L*(TbB - To) + L_B - CpB_V*(TbB - To) ; // Latent heat of vaporisation of B 
 // ya = 0
H = 0*(L_A + CpA_V*(TbA - To)) + 1*(L_B + CpB_V*(TbB - To)) ; // Enthalpy of saturated vapor at ya = 0
 // xa = 1
Hvap = 1*(L_A + CpA_V*(TbA-To)) ; // Enthalpy of vapor
 // xa = 0.5 at 92 C
hliq = 0.5*(CpB_V*(92 - To)) + 0.5*(CpB_L*(92 - To)) ; // Enthalp of sat. liq. at 92 C
 // xa = 0.5 at 98.8 C
Hvap1 = 0.5*(L_A + CpA_V*(98.8 - To)) + 0.5*(L_B + CpB_V*(98.8 - To)) ; // Enthalpy of sat. vap.at 98C
end Ex11_6_1;
//==================================================================
