// C.J. Geankopolis, Transport processs and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-11 Vapor liquid separation processes
//Example 11_7_1 Page:682
//Title: Boiling point of multicomponent liquid  
//================================================
model Ex11_7_1

//===============
//Parameter section
parameter Real x[4] = {0.4,0.25,0.2,0.15} "Mole fraction of liquid components";
parameter Real k1[4] = {1.68,0.63,0.245,0.093} "Distribution coefficients at 65 C";
parameter Real k2[4] = {1.86,0.71,0.2815,0.11} "Distribution coefficients at 70 C";

//==============
//Variable section
Real Kc1(unit = "-") "Ratio of vapor pressure to total pressure";
//Real Kc2(unit = "-") "Ratio of vapor pressure to total pressure";
//Real y(unit = "-") "Mole fraction of vapor";
Real alpha1[4] "Relative volataility";
Real alphax1[4] "Product of relative volataility and liq. mol frac";

//================
//Equation secion
equation
// The distribution coefficient at 70 C is directly calculated
for i in 1:4 loop
alpha1[i] = k2[i]/k2[3] ; // Relative volataility
alphax1[i] = x[i]*alpha1[i] ; // Product of relative volataility and liq. mol frac
end for;
Kc1 = 1/sum(alphax1[:]) ; // DIstribution coefficient of C
 // The value oh Kc1 is found to be same at 70 C
end Ex11_7_1;
//=====================================================
