// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-12 Liquid-Liquid and fluid-solid separation processes
//Example 12_10_1 Page:735
//Title: Counter current leaching of oil from metal
//================================================
model Ex12_10_1

//==============
//Parameter section
parameter Real A(unit = "kg oil") = 800 "Amount of solute present";
parameter Real B(unit = "kg of inert") = 2000 "Inert present in solution";
parameter Real C(unit = "kg of benzene") = 50 "Insoluble inert";
parameter Real S(unit = "kg solvent") = 1310 "Inlet flow rate of freah solvent";
parameter Real p(unit = "kg oil") = 20 "Amount ofsolute in solvent";
parameter Real Ls(unit = "kg oil") = 120 "Amount of oil present in leached oil";
 // After plotting the found values in graph, 12.10-3
parameter Real xa1(unit = "-") = 0.6 "Amount of oil present after stage 1";
parameter Real ya1(unit = "-") = 0.118 "Oil present in solution after stage 1";

//=============
//Variable section
Real Lo(unit = "kg/hr") "Flow rate of untreated solid";
Real yao(unit ="-") "Amount of solute per kg of solution";
Real No(unit = "kg/kg") "Amount of inert to that of untreated solid";
Real Vn(unit = "kg/hr") "Leaching solvent";
Real xan(unit = "-") "Amount of oil to that of leaching solvent";
Real M(unit = "-") "Mass flow rate of mixed solution";
Real xam(unit = "-") "Concentration of mixed flow rate";
Real Nm(unit = "-") "Amount of inert";
Real Vo(unit = "kg/hr") " Flow rate of solvent after 1st stage";
Real Ln(unit = "kg/hr") "Flow rate of solution after 1st stage";

//==============
//Equation section
equation
Lo = A + C; // Flow rate of untreated solid
yao = A/(A + C); // Amount of solute per kg of solution
No =  B/(A + C) ; // Amount of inert to that of untreated solid
Vn = S + p ; // Leaching solvent
xan = p/Vn ; // Amount of oil to that of leaching solvent
Lo + Vn = M; // Total flow rate
Lo*yao + Vn*xan = M*xam ;// Concentration of mixed flow rate
B = Nm*M ; // Amount of inert
Ln + Vo = M; // Flow rate of solvent after 1st stage
Ln*ya1 + Vo*xa1 = M*xam ; // Flow rate of solution after 1st stage
 // The number of stages is found to be 3.9
end Ex12_10_1;
//=====================================================
