// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-12 Liquid-Liquid and fluid-solid separation processes
//Example 12_11_1 Page:739
//Title: Yield of crystallization process
//================================================
model Ex12_11_1

//==============
//Parameter section
parameter Real F(unit = "kg/hr") = 10000 "Feed flow rate";
parameter Real xf(unit = "-") = 0.3 "Composition of feed";
parameter Real sol(unit = "kg/kg") = 21.5 "Solublity of solute in the solution";
parameter Real T(unit = "kg") = 100 "Total amount of water present";
parameter Real xw1(unit = "-") = 0 "Amount of water evaporated in case 1";
// Case 2
parameter Real xw2(unit = "-") = 0.03 "Amount of water getting evaporated in case 2";

//==============
//Variable section
Real C_1(unit = "kg/hr") "Amount of crystals formed";
Real S_1(unit = "kg/hr") "Amount of saturated solution formed";
Real C_2(unit = "kg/hr") "Amount of crystals formed in case 2";
Real S_2(unit = "kg/hr") "Amount of saturated solution formed";

//==============
//Equation section
equation
(1-xf)*F = T*S_1/(T + sol) + (180.2/286.2)*C_1 ; // Water  balance 
// Molecular wt of crystal is 286.2
// Molecular wt of  10.H2O is 180.2
xf*F = sol*S_1/(T + sol) + (106/286.2)*C_1  ; // Solute balance
// Molecular wt of Na2CO3 is 106
//Case 2
(1-xf)*F =  T*S_2/(T + sol) + (180.2/286.2)*C_2 + F*xw2 ; // Water balance for 3% of water evaporated
xf*F = sol*S_2/(T + sol) + (106/286.2)*C_2  ; // Solute balance for 3% of water evaporated
 // Molecular wt of crystal is 286.2
 // Molecular wt of  10.H2O is 180.2
 // Molecular wt of Na2CO3 is 106
end Ex12_11_1;
//======================================================
