// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-12 Liquid-Liquid and fluid-solid separation processes
//Example 12_2_1 Page:700
//Title: Batch adsorption on activated carbon
//================================================
model Ex12_2_1

//==============
//Parameter section
parameter Real M(unit = "kg-carbon") = 1.4 "Amount of adsorbate";
parameter Real S(unit = "m^3") = 1 "Amount of solution";
parameter Real qf(unit = "kg-phenol/kg-carbon") = 0 "Initial amount got adsorbed";
parameter Real cf(unit = "kg-phenol/m^3") = 0.21 "Initial concentration of phenol in solution";

//==============
//Variable section
Real q(unit = "kg-phenol/kg-adsorbent") "Amount of solute adsorbed to amount of solvent";
Real c(unit = "kg-phenol/m^3 of solution") "Amount of phenol present per m^3 of solution";
Real ext(unit = "%")  "AMount of phenol extracted";

//==============
//Equatiom section
equation
qf*M+cf*S = q*M+c*S ; // Overall material balance equation
q = 0.199*(c^0.229) ; // Equilibrium freundlich relation from Ex 12.1.1
ext= ((cf - c)/cf)*100 ; // Amount of phenol extracted
end Ex12_2_1;
//====================================================
