// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-12 Liquid-Liquid and fluid-solid separation processes
//Example 12_8_1 Page:726
//Title: Prediction of time for batch leaching
//================================================
model Ex12_8_1

//==============
//Parameter section
parameter Real t1(unit = "hr") = 3.11"Time required for leaching of particle of size a1";
parameter Real a1(unit = "mm") = 2 "Diameter of particle of size 1";
parameter Real a2(unit = "mm") = 1.5 "Diameter of particle of size 2";

//==============
//Variable section
Real t2(unit = "h") "Time required for leaching of particle of size a2";

//==============
//Equation section
equation
t2 = t1*(a2/2)^2/(a1/2)^2 ; // Time required for leaching size a2
end Ex12_8_1;
//===============================================
